// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.verb;

import ORG.oclc.oai.util.OAIUtil;
import org.xml.sax.Attributes;
import java.util.Iterator;
import org.xml.sax.helpers.XMLReaderFactory;
import java.io.IOException;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import java.io.Reader;
import org.xml.sax.InputSource;
import java.io.StringReader;
import org.xml.sax.ContentHandler;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.helpers.DefaultHandler;

public class Header extends DefaultHandler
{
    private static final boolean debug = false;
    private String header;
    private static HashMap xmlReaders;
    private boolean identifierCapture;
    private StringBuffer identifier;
    private boolean datestampCapture;
    private StringBuffer datestamp;
    private boolean setSpecCapture;
    private ArrayList setSpecs;
    private StringBuffer setSpec;
    private String status;
    
    public Header(final String header) throws SAXException, IOException {
        this.header = null;
        this.identifierCapture = false;
        this.identifier = new StringBuffer();
        this.datestampCapture = false;
        this.datestamp = new StringBuffer();
        this.setSpecCapture = false;
        this.setSpecs = new ArrayList();
        this.status = null;
        this.header = header;
        final XMLReader xmlReader = this.getXMLReader();
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(new StringReader(header)));
        }
        catch (SAXException e) {
            System.out.println("Header.Header: header=" + header);
            e.printStackTrace();
            throw e;
        }
    }
    
    private XMLReader getXMLReader() throws SAXException {
        final Thread currentThread = Thread.currentThread();
        XMLReader xmlReader = Header.xmlReaders.get(currentThread);
        if (xmlReader == null) {
            try {
                xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException e) {
                try {
                    xmlReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (SAXException e2) {
                    try {
                        xmlReader = XMLReaderFactory.createXMLReader("com.bluecase.xml.Piccolo");
                    }
                    catch (SAXException e3) {
                        try {
                            xmlReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                        }
                        catch (SAXException e4) {
                            try {
                                xmlReader = XMLReaderFactory.createXMLReader();
                            }
                            catch (SAXException e5) {
                                throw new SAXException("No SAX parser available");
                            }
                        }
                    }
                }
            }
            Header.xmlReaders.put(currentThread, xmlReader);
        }
        return xmlReader;
    }
    
    public String getHeaderXML() {
        return this.header;
    }
    
    public boolean isDeleted() {
        return "deleted".equals(this.status);
    }
    
    public String getIdentifier() {
        return this.identifier.toString();
    }
    
    public String getDatestamp() {
        return this.datestamp.toString();
    }
    
    public Iterator getSetSpecs() {
        if (this.setSpecs.size() > 0) {
            return this.setSpecs.iterator();
        }
        return null;
    }
    
    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("Header.identifier=");
        sb.append(this.getIdentifier());
        sb.append("\nHeader.datestamp=");
        sb.append(this.getDatestamp());
        final Iterator setSpecs = this.getSetSpecs();
        if (setSpecs != null) {
            while (setSpecs.hasNext()) {
                sb.append("\nHeader.setSpec=");
                sb.append(setSpecs.next());
            }
        }
        sb.append("\nHeader.status=");
        sb.append(this.status);
        sb.append("\n");
        return sb.toString();
    }
    
    public void startElement(final String namespaceURI, final String localName, final String qName, final Attributes attrs) {
        final String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (fullName.equals("#identifier")) {
            this.identifierCapture = true;
        }
        else if (fullName.equals("#datestamp")) {
            this.datestampCapture = true;
        }
        else if (fullName.equals("#setSpec")) {
            this.setSpecCapture = true;
            this.setSpec = new StringBuffer();
        }
        else if (!fullName.equals("#header")) {
            if (fullName.equals("#header")) {
                for (int length = attrs.getLength(), i = 0; i < length; ++i) {
                    final String aEName = HarvesterVerb.fullName(attrs.getURI(i), attrs.getLocalName(i));
                    if (HarvesterVerb.OAI20_STATUS.equals(aEName)) {
                        this.status = attrs.getValue(i);
                    }
                }
            }
            else {
                System.out.println("Unrecognized element: " + qName);
            }
        }
    }
    
    public void endElement(final String namespaceURI, final String localName, final String qName) throws SAXException {
        final String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (!this.identifierCapture) {
            if (!this.datestampCapture) {
                if (this.setSpecCapture) {}
            }
        }
        if (fullName.equals("#identifier")) {
            this.identifierCapture = false;
        }
        else if (fullName.equals("#datestamp")) {
            this.datestampCapture = false;
        }
        else if (fullName.equals("#setSpec")) {
            this.setSpecs.add(this.setSpec.toString());
            this.setSpecCapture = false;
        }
    }
    
    public void characters(final char[] buf, final int offset, final int len) {
        final String s = new String(buf, offset, len);
        if (this.identifierCapture) {
            this.identifier.append(OAIUtil.xmlEncode(s));
        }
        else if (this.datestampCapture) {
            this.datestamp.append(OAIUtil.xmlEncode(s));
        }
        else if (this.setSpecCapture) {
            this.setSpec.append(OAIUtil.xmlEncode(s));
        }
        else if (s.trim().length() > 0) {
            System.out.println("Unrecognized content:" + s);
        }
    }
    
    static {
        Header.xmlReaders = new HashMap();
    }
}
